//
//  OPLicense.h
//  OnePasswordOSX
//
//  Created by Roustem Karimov on 8/29/2013.
//  Copyright (c) 2013 AgileBits Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface OPLicense : NSObject

+ (NSDictionary *)teamsAccountLicense; // See OPB-267

@property (nonatomic, readonly, copy) NSDictionary * info;
@property (nonatomic, readonly, getter=isPremium) BOOL premium;

- (id)initWithPrimeKey:(NSData *)primeKey;
- (id)initWithPrimeKeyString:(NSString *)primeKeyString;

- (NSDictionary *)addData:(NSData *)data error:(NSError **)error;
- (void)reloadInfoFromLicensesOnDisk;
- (NSInteger)trialDaysRemainingForDaysSinceOnePassword5Migration:(NSInteger)daysUsed;

@end
